package ch.frankel.blog.hibernate;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

import java.sql.Date;

import org.hibernate.Session;
import org.hibernate.usertype.UserType;
import org.testng.annotations.Test;

import ch.frankel.blog.hibernate.model.Owner;

/**
 * Test class to check use of {@link UserType}.
 * 
 * @author Nicolas Frnkel
 */
public class TestPart3 extends AbstractTest {

    /**
     * Test the getting.
     */
    @SuppressWarnings("deprecation")
    @Test
    public void testTypeMapper() {

        Session session = factory.getCurrentSession();

        session.getTransaction().begin();

        Owner owner = (Owner) session.get(Owner.class, 1);

        assertNotNull(owner);

        Date date = new Date(109, 11, 12);

        assertEquals(owner.getDate(), date);
    }
}
